/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.support.v4.media.session;

import android.net.Uri;
import android.os.Bundle;

import androidx.annotation.RequiresApi;

@RequiresApi(23)
class MediaSessionCompatApi23 {

    public static Object createCallback(Callback callback) {
        return new CallbackProxy<Callback>(callback);
    }

    public interface Callback extends MediaSessionCompatApi21.Callback {
        public void onPlayFromUri(Uri uri, Bundle extras);
    }

    static class CallbackProxy<T extends Callback>
            extends MediaSessionCompatApi21.CallbackProxy<T> {
        public CallbackProxy(T callback) {
            super(callback);
        }

        @Override
        public void onPlayFromUri(Uri uri, Bundle extras) {
            MediaSessionCompat.ensureClassLoader(extras);
            mCallback.onPlayFromUri(uri, extras);
        }
    }

    private MediaSessionCompatApi23() {
    }
}
